///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef __CEJSExtVariant_H__
#define __CEJSExtVariant_H__

#include <CECom.h>
#include "CEComAtomicSupport.h"
#include "ICEJSExtVariant.h"

#include "runtime/JSValue.h"
#include "PlatformString.h"

class CEJSExtVariant
{
public:
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

public:
	void AddRef()
	{
		CEComAtomicIncrement(_refCount);
	}

	void Release()
	{
		CEATOMIC refCount = CEComAtomicDecrement(_refCount);
		if (refCount == 0)
		{
			delete this;
		}
	}
private:
	CEATOMIC _refCount;

	/////////////////////////////////
	// factory
	/////////////////////////////////
public:
	static CEHResult createFromUndefined(JSC::ExecState* exec, CEJSExtVariant** pVariantOut);
	static CEHResult createFromNull(JSC::ExecState* exec, CEJSExtVariant** pVariantOut);
	static CEHResult createFromBoolean(JSC::ExecState* exec, UINT8 booleanValue, CEJSExtVariant** pVariantOut);
	static CEHResult createFromInt32(JSC::ExecState* exec, INT32 int32Value, CEJSExtVariant** pVariantOut);
	static CEHResult createFromNumber(JSC::ExecState* exec, double doubleValue, CEJSExtVariant** pVariantOut);
	static CEHResult createFromString(JSC::ExecState* exec, const UTF16CHAR* pCharArray16, UINT32 numOfChars16, CEJSExtVariant** pVariantOut);
	static CEHResult createFromPropertyValue(JSC::ExecState* exec, JSC::JSValue* pPropertyValue, CEJSExtVariant** pVariantOut);

	////////////////////////////////
	//  constructor / destructor
	////////////////////////////////
public:
	CEJSExtVariant();

public:
	virtual ~CEJSExtVariant();

	////////////////////////////////
	//  Initializer
	////////////////////////////////
private:
	CEHResult _initWithUndefined(JSC::ExecState* exec);
	CEHResult _initWithNull(JSC::ExecState* exec);
	CEHResult _initWithBoolean(JSC::ExecState* exec, bool booleanValue);
	CEHResult _initWithInt32(JSC::ExecState* exec, INT32 int32Value);
	CEHResult _initWithNumber(JSC::ExecState* exec, double numberValue);
	CEHResult _initWithString(JSC::ExecState* exec, const UTF16CHAR* pCharArray16, UINT32 numOfChars16);

	////////////////////////////////
	//  operation
	////////////////////////////////
public:
	JSC::JSValue getPropertyValue() const { return _propertyValue; }

	////////////////////////////////
	//  ICEJSExtVariant methods
	////////////////////////////////
public:
	CEHResult getType(CEJSExtVariantType* typeOut);
	CEHResult toBoolean(UINT8* booleanOut);
	CEHResult toNumber(double* numberOut);
	CEHResult toInteger(double* integerOut);
	CEHResult toInt32(INT32* int32Out);
	CEHResult toUint32(UINT32* uint32Out);
	CEHResult toUint16(UINT16* uint16Out);
	CEHResult toString(const UTF16CHAR **const pCharArray16Out, UINT32 *const numOfChars16Out);
protected:
	// ICEJSExtVariant vptr
	const void* _extVariantVptr;

	////////////////////////////////
	//  data members
	////////////////////////////////
private:
	JSC::JSValue _propertyValue;
	WebCore::String _stringValue;
};

#endif // __CEJSExtVariant_H__
