///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef JSUtilityClientSilk_h
#define JSUtilityClientSilk_h

#ifdef __cplusplus
extern "C" {
#endif

// utility functions prototype
void addStaticProperty(WebCore::JSDOMWindow* window, const JSC::Identifier& name, JSC::JSValue value);
void addNativeFunction(WebCore::JSDOMWindow* window, const JSC::Identifier& name, JSC::NativeFunction cfunc);
void addNativeHandlingProperty(WebCore::JSDOMWindow* window, const JSC::Identifier& name, JSC::NativeFunction getter, JSC::NativeFunction setter);
void addNewFunction(WebCore::JSDOMWindow* window, const JSC::Identifier& name, const JSC::UString& source);

#ifdef __cplusplus
}
#endif

#endif /* JSUtilityClientSilk_h */
