/*
 * Copyright (C) 2006, 2007, 2008 Apple Inc. All rights reserved.
 * Copyright     2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef FrameLoaderClientSilk_h
#define FrameLoaderClientSilk_h

#include "config.h"
#include "PassRefPtr.h"
#include "UString.h"
#include "PlatformString.h"
#include "FrameLoader.h"
#include "FrameLoaderClient.h"
#include "ResourceError.h"
#include "HTMLFormElement.h"
#include "FormState.h"
#include "DocumentLoader.h"
#include "Frame.h"
#include "FrameView.h"
#include "NavigationAction.h"
#include "ResourceRequest.h"
#include "HashMap.h"

class CEWebKitWindowImpl;
class FrameLoaderClientSilk : public WebCore::FrameLoaderClient
{
public:
	FrameLoaderClientSilk(CEWebKitWindowImpl* window);
	CEWebKitWindowImpl* getWindow() { return _window; }

	void setFrame(WebCore::Frame* frame) { _frame = frame; }
private:
	CEWebKitWindowImpl* _window;
	WebCore::Frame* _frame;
	WebCore::KURL _newTargetUrl;

public:
    virtual void frameLoaderDestroyed();
	virtual bool hasWebView() const;
    virtual void makeRepresentation(WebCore::DocumentLoader*);
	virtual void forceLayout();
    virtual void forceLayoutForNonHTML();
    virtual void setCopiesOnScroll();
    virtual void detachedFromParent2();
    virtual void detachedFromParent3();
	virtual void assignIdentifierToInitialRequest(unsigned long identifier, WebCore::DocumentLoader* documentLoader, const WebCore::ResourceRequest& resourceRequest);
        virtual bool shouldUseCredentialStorage(WebCore::DocumentLoader*, unsigned long identifier) { return false; };
	virtual void dispatchWillSendRequest(WebCore::DocumentLoader* documentLoader, unsigned long identifier, WebCore::ResourceRequest& resourceRequest, const WebCore::ResourceResponse& redirectResponse);
	virtual void dispatchDidReceiveAuthenticationChallenge(WebCore::DocumentLoader* documentLoader, unsigned long identifier, const WebCore::AuthenticationChallenge&);
	virtual void dispatchDidCancelAuthenticationChallenge(WebCore::DocumentLoader* documentLoader, unsigned long identifier, const WebCore::AuthenticationChallenge&);        
	virtual void dispatchDidReceiveResponse(WebCore::DocumentLoader* documentLoader, unsigned long identifier, const WebCore::ResourceResponse& resourceResponse);
	virtual void dispatchDidReceiveContentLength(WebCore::DocumentLoader* documentLoader, unsigned long identifier, int lengthReceived);
	virtual void dispatchDidFinishLoading(WebCore::DocumentLoader* documentLoader, unsigned long identifier);
	virtual void dispatchDidFailLoading(WebCore::DocumentLoader* documentLoader, unsigned long identifier, const WebCore::ResourceError& err);
	virtual bool dispatchDidLoadResourceFromMemoryCache(WebCore::DocumentLoader* documentLoader, const WebCore::ResourceRequest& resourceRequest, const WebCore::ResourceResponse& resourceResponse, int length);
	virtual void dispatchDidLoadResourceByXMLHttpRequest(unsigned long, const WebCore::ScriptString&) {};

	virtual void dispatchDidHandleOnloadEvents();
	virtual void dispatchDidReceiveServerRedirectForProvisionalLoad();
	virtual void dispatchDidCancelClientRedirect();
	virtual void dispatchWillPerformClientRedirect(const WebCore::KURL& url, double interval, double fireDate);
	virtual void dispatchDidChangeLocationWithinPage();
	virtual void dispatchWillClose();
	virtual void dispatchDidReceiveIcon();
	virtual void dispatchDidStartProvisionalLoad();
	virtual void dispatchDidReceiveTitle(const WebCore::String& title);
	virtual void dispatchDidCommitLoad();
	virtual void dispatchDidFailProvisionalLoad(const WebCore::ResourceError& error);
	virtual void dispatchDidFailLoad(const WebCore::ResourceError& err);
	virtual void dispatchDidFinishDocumentLoad();
	virtual void dispatchDidFinishLoad();
	virtual void dispatchDidFirstLayout();
        virtual void dispatchDidFirstVisuallyNonEmptyLayout() {};

	virtual WebCore::Frame* dispatchCreatePage();
	virtual void dispatchShow();

	virtual void dispatchDecidePolicyForMIMEType(WebCore::FramePolicyFunction func, const WebCore::String& MIMEType, const WebCore::ResourceRequest&);
	virtual void dispatchDecidePolicyForNewWindowAction(WebCore::FramePolicyFunction func, const WebCore::NavigationAction& action, const WebCore::ResourceRequest& resourceRequest, PassRefPtr<WebCore::FormState> state, const WebCore::String& frameName);
	virtual void dispatchDecidePolicyForNavigationAction(WebCore::FramePolicyFunction func, const WebCore::NavigationAction& action, const WebCore::ResourceRequest& resourceRequest, PassRefPtr<WebCore::FormState> state);


    virtual void cancelPolicyCheck();
    virtual void dispatchWillSubmitForm(WebCore::FramePolicyFunction func, PassRefPtr<WebCore::FormState>);
	virtual void dispatchDidLoadMainResource(WebCore::DocumentLoader* documentLoader);
    virtual void revertToProvisionalState(WebCore::DocumentLoader*);
	virtual void setMainDocumentError(WebCore::DocumentLoader* documentLoader, const WebCore::ResourceError& err);
    virtual void setMainFrameDocumentReady(bool);
    virtual void willChangeTitle(WebCore::DocumentLoader* documentLoader);
    virtual void didChangeTitle(WebCore::DocumentLoader* documentLoader);

	virtual void committedLoad(WebCore::DocumentLoader* documentLoader, const char* data, int length);
	virtual void finishedLoading(WebCore::DocumentLoader* documentLoader);
        
	virtual void updateGlobalHistory();
	virtual void updateGlobalHistoryRedirectLinks() {};
	virtual bool shouldGoToHistoryItem(WebCore::HistoryItem* historyItem) const;


	virtual void postProgressStartedNotification();
	virtual void postProgressEstimateChangedNotification();
	virtual void postProgressFinishedNotification();
	
    virtual bool canHandleRequest(const WebCore::ResourceRequest&) const;
    virtual bool canShowMIMEType(const WebCore::String& MIMEType) const;
    virtual bool representationExistsForURLScheme(const WebCore::String& URLScheme) const;
    virtual WebCore::String generatedMIMETypeForURLScheme(const WebCore::String& URLScheme) const;
    virtual void frameLoadCompleted();
    virtual void restoreViewState();
    virtual void provisionalLoadStarted();
    virtual bool shouldTreatURLAsSameAsCurrent(const WebCore::KURL&) const;
    virtual void addHistoryItemForFragmentScroll();
    virtual void didFinishLoad();
    virtual void prepareForDataSourceReplacement();
	
	virtual PassRefPtr<WebCore::DocumentLoader> createDocumentLoader(const WebCore::ResourceRequest& request, const WebCore::SubstituteData& substitutedata);
	virtual void setTitle(const WebCore::String& title, const WebCore::KURL& url);
		

    virtual WebCore::String userAgent(const WebCore::KURL& url);

    virtual void savePlatformDataToCachedFrame(WebCore::CachedFrame*) {};
    virtual void transitionToCommittedFromCachedFrame(WebCore::CachedFrame*) {};
	virtual void transitionToCommittedForNewPage();
	virtual bool canCachePage() const;

    virtual void saveViewStateToItem(WebCore::HistoryItem *);
    virtual WebCore::ResourceError cancelledError(const WebCore::ResourceRequest& request);
    virtual WebCore::ResourceError blockedError(const WebCore::ResourceRequest& request);
    virtual WebCore::ResourceError cannotShowURLError(const WebCore::ResourceRequest& request);
    virtual WebCore::ResourceError interruptForPolicyChangeError(const WebCore::ResourceRequest& request);
    virtual WebCore::ResourceError cannotShowMIMETypeError(const WebCore::ResourceResponse& response);
    virtual WebCore::ResourceError fileDoesNotExistError(const WebCore::ResourceResponse& response);
    virtual WebCore::ResourceError pluginWillHandleLoadError(const WebCore::ResourceResponse& response);
    virtual bool shouldFallBack(const WebCore::ResourceError&);
    virtual void dispatchUnableToImplementPolicy(const WebCore::ResourceError&);
    virtual void download(WebCore::ResourceHandle*, const WebCore::ResourceRequest&, const WebCore::ResourceRequest&, const WebCore::ResourceResponse&);
	virtual WTF::PassRefPtr<WebCore::Frame> createFrame(const WebCore::KURL& url, const WebCore::String& name, WebCore::HTMLFrameOwnerElement* ownerElement, const WebCore::String& referrer, bool allowsScrolling, int marginWidth, int marginHeight);
    virtual WTF::PassRefPtr<WebCore::Widget> createPlugin(const WebCore::IntSize&, WebCore::HTMLPlugInElement*, const WebCore::KURL&, const WTF::Vector<WebCore::String>&, const WTF::Vector<WebCore::String>&, const WebCore::String&, bool);
	virtual void redirectDataToPlugin(WebCore::Widget* pluginWidget);

    virtual void startDownload(const WebCore::ResourceRequest&);
        
    virtual WTF::PassRefPtr<WebCore::Widget> createJavaAppletWidget(const WebCore::IntSize&, WebCore::HTMLAppletElement*, const WebCore::KURL& baseURL, const Vector<WebCore::String>& paramNames, const Vector<WebCore::String>& paramValues);

    virtual WebCore::ObjectContentType objectContentType(const WebCore::KURL& url, const WebCore::String& mimeType);
    virtual WebCore::String overrideMediaType() const;

    virtual void windowObjectCleared();
	virtual void documentElementAvailable() {};
    virtual void didPerformFirstNavigation() const;

    virtual void registerForIconNotification(bool listen);

	bool confirmPlugin(bool result, bool keepResult, void *const cData);
	bool getComittedLoadNow() { return _isCommittedLoad; }
	void setComittedLoad(bool comittedload) { _isCommittedLoad=comittedload; }

private:
	HashMap<unsigned long,bool> _idMap;

	bool _isCEA2014ModeEnabled;
	bool _isCommittedLoad;

public:

	CEHResult setCertificate(void* certIn);
	CEHResult getCertificate(const void** certOut);

    void setIdentifier(unsigned long identifier, bool isMainResource);
private:
	void* _cert;
};

#endif /* FrameLoaderClientSilk_h */
