/*
 * Copyright (C) 2006, 2007 Apple Inc.  All rights reserved.
 * Copyright     2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
#ifndef EditorClientSilk_h
#define EditorClientSilk_h

#include "EditorClient.h"
#include "EditCommand.h"
#include "Forward.h"

class CEWebKitFrameWindowImpl;
class EditorClientSilk : public WebCore::EditorClient
{
public:
	EditorClientSilk(CEWebKitFrameWindowImpl* frameWindow);
	CEWebKitFrameWindowImpl* getFrameWindow() { return _frameWindow; }

private:
	CEWebKitFrameWindowImpl* _frameWindow;

public:
	virtual void pageDestroyed();

    virtual bool isContinuousSpellCheckingEnabled();
    virtual void toggleGrammarChecking();
    virtual bool isGrammarCheckingEnabled();
    virtual void toggleContinuousSpellChecking();
    virtual int spellCheckerDocumentTag();

    virtual bool isEditable();

    virtual bool shouldBeginEditing(WebCore::Range* range);
    virtual bool shouldEndEditing(WebCore::Range* range);
    virtual bool shouldInsertText(const WebCore::String& str, WebCore::Range* range, WebCore::EditorInsertAction insertAction);

    virtual void didBeginEditing();
    virtual void didEndEditing();
    virtual void didWriteSelectionToPasteboard();
    virtual void didSetSelectionTypesForPasteboard();

    virtual void respondToChangedContents();
    virtual void respondToChangedSelection();

    virtual bool shouldShowDeleteInterface(WebCore::HTMLElement* element);
    virtual bool shouldDeleteRange(WebCore::Range* range);

    virtual bool shouldInsertNode(WebCore::Node* node, WebCore::Range* replacingRange, WebCore::EditorInsertAction insertAction);
    virtual bool shouldApplyStyle(WebCore::CSSStyleDeclaration* styleDecl, WebCore::Range* range);
    virtual bool shouldMoveRangeAfterDelete(WebCore::Range* range1, WebCore::Range* range2);
    virtual bool shouldChangeTypingStyle(WebCore::CSSStyleDeclaration* currentStyle, WebCore::CSSStyleDeclaration* toProposedStyle);

    virtual bool smartInsertDeleteEnabled();
    virtual bool isSelectTrailingWhitespaceEnabled() { return false; }

    virtual void registerCommandForUndo(PassRefPtr<WebCore::EditCommand> command);
    virtual void registerCommandForRedo(PassRefPtr<WebCore::EditCommand> command);
    virtual void clearUndoRedoOperations();

    virtual bool canUndo() const;
    virtual bool canRedo() const;
    
    virtual void undo();
    virtual void redo();    
    
    virtual bool shouldChangeSelectedRange(WebCore::Range* fromRange, WebCore::Range* toRange, WebCore::EAffinity affinity, bool stillSelecting);
    virtual void textFieldDidBeginEditing(WebCore::Element* element);
    virtual void textFieldDidEndEditing(WebCore::Element* element);
    virtual void textDidChangeInTextField(WebCore::Element* element);
    virtual bool doTextFieldCommandFromEvent(WebCore::Element* element, WebCore::KeyboardEvent* keyEvent);
    virtual void textWillBeDeletedInTextField(WebCore::Element* input);
    virtual void textDidChangeInTextArea(WebCore::Element* element);
	
    virtual void handleKeyboardEvent(WebCore::KeyboardEvent* keyEvent);
    virtual void handleInputMethodKeydown(WebCore::KeyboardEvent* keyEvent);

    virtual void ignoreWordInSpellDocument(const WebCore::String& str);
    virtual void learnWord(const WebCore::String& str);
    virtual void checkSpellingOfString(const UChar* uchars, int length, int* misspellingLocation, int* misspellingLength);
    virtual WebCore::String getAutoCorrectSuggestionForMisspelledWord(const WebCore::String&);
    virtual void checkGrammarOfString(const UChar* uchars, int length, Vector<WebCore::GrammarDetail>& details, int* badGrammarLocation, int* badGrammarLength);
    virtual void updateSpellingUIWithGrammarString(const WebCore::String& str, const WebCore::GrammarDetail& detail);
    virtual void updateSpellingUIWithMisspelledWord(const WebCore::String& str);
    virtual void showSpellingUI(bool show);
    virtual bool spellingUIIsShowing();
    virtual void getGuessesForWord(const WebCore::String& str, Vector<WebCore::String>& guesses);

    virtual void setInputMethodState(bool state);

};

#endif /* EditorClientSilk_h */
