/*
 * Copyright (C) 2006, 2007, 2008 Apple, Inc. All rights reserved.
 * Copyright     2009 Sony Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef ChromeClientSilk_h
#define ChromeClientSilk_h


#include "ChromeClient.h"
#include "GraphicsContext.h"
#include "FocusDirection.h"
#include "ScrollTypes.h"
#include "FileChooser.h"
#include "Forward.h"
#include "CEWebKitFrameWindowImpl.h"

class CEWebKitFrameWindowImpl;
class ChromeClientSilk : public WebCore::ChromeClient
{
public:
	ChromeClientSilk(CEWebKitFrameWindowImpl* frameWindow);
	CEWebKitFrameWindowImpl* getFrameWindow() { return _frameWindow; }

private:
	CEWebKitFrameWindowImpl* _frameWindow;
	WebCore::Node* _lastMouseOverNode;

public:
	virtual void chromeDestroyed();
        
	virtual void setWindowRect(const WebCore::FloatRect& flatRect);
	virtual WebCore::FloatRect windowRect();
        
	virtual WebCore::FloatRect pageRect();
        
	virtual float scaleFactor();
    
	virtual void focus();
	virtual void unfocus();

	virtual bool canTakeFocus(WebCore::FocusDirection focusDir);
	virtual void takeFocus(WebCore::FocusDirection focusDir);

    virtual void focusedNodeChanged(WebCore::Node*);

	virtual WebCore::Page* createWindow(WebCore::Frame* frame, const WebCore::FrameLoadRequest& frameLoadRequest, const WebCore::WindowFeatures& windowFeature);
	virtual void show();

	virtual bool canRunModal();
	virtual void runModal();

	virtual void setToolbarsVisible(bool visible);
	virtual bool toolbarsVisible();
        
	virtual void setStatusbarVisible(bool visible);
	virtual bool statusbarVisible();
        
	virtual void setScrollbarsVisible(bool visible);
	virtual bool scrollbarsVisible();
        
	virtual void setMenubarVisible(bool visible);
	virtual bool menubarVisible();

	virtual void setResizable(bool resizable);
        
	virtual void addMessageToConsole(WebCore::MessageSource source, WebCore::MessageLevel level, const WebCore::String& message, unsigned int lineNumber, const WebCore::String& sourceID);

	virtual bool canRunBeforeUnloadConfirmPanel();
	virtual bool runBeforeUnloadConfirmPanel(const WebCore::String& message, WebCore::Frame* frame);

	virtual void closeWindowSoon();
        
	virtual void runJavaScriptAlert(WebCore::Frame* frame, const WebCore::String& message);
	virtual bool runJavaScriptConfirm(WebCore::Frame* frame, const WebCore::String& message);
	virtual bool runJavaScriptPrompt(WebCore::Frame* frame, const WebCore::String& message, const WebCore::String& defaultValue, WebCore::String& result);
	virtual void setStatusbarText(const WebCore::String& message);
	virtual bool shouldInterruptJavaScript();
	virtual bool tabsToLinks() const;

	virtual WebCore::IntRect windowResizerRect() const;

	// Methods used by HostWindow.
	virtual void repaint(const WebCore::IntRect& rect, bool contentChanged, bool immediate = false, bool repaintContentOnly = false);
	virtual void scroll(const WebCore::IntSize& scrollDelta, const WebCore::IntRect& rectToScroll, const WebCore::IntRect& clipRect);
	virtual WebCore::IntPoint screenToWindow(const WebCore::IntPoint& pt) const;
	virtual WebCore::IntRect windowToScreen(const WebCore::IntRect& pt) const;
	virtual PlatformWidget platformWindow() const;
        virtual void contentsSizeChanged(WebCore::Frame*, const WebCore::IntSize&) const {};
	// End methods used by HostWindow.

	virtual void mouseDidMoveOverElement(const WebCore::HitTestResult& result, unsigned modifierFlags);

	virtual void setToolTip(const WebCore::String& message);

	virtual void print(WebCore::Frame* farme);

#if ENABLE(DATABASE)
	virtual void exceededDatabaseQuota(WebCore::Frame* frame, const WebCore::String& databaseName);
#endif

	virtual void runOpenPanel(WebCore::Frame* frame, PassRefPtr<WebCore::FileChooser> fileChooser);
	virtual bool shouldReplaceWithGeneratedFileForUpload(const WebCore::String& name, WebCore::String& path);
        virtual WebCore::String generateReplacementFile(const WebCore::String& path);

        virtual void formStateDidChange(const WebCore::Node*) { }
    PassOwnPtr<WebCore::HTMLParserQuirks> createHTMLParserQuirks() { return 0; }

    virtual bool setCursor(WebCore::PlatformCursorHandle);

#if USE(ACCELERATED_COMPOSITING) 
	virtual void attachRootGraphicsLayer(WebCore::Frame*, WebCore::GraphicsLayer*); 
	virtual void setNeedsOneShotDrawingSynchronization(); 
	virtual void scheduleCompositingLayerSync();
#endif 

    virtual void scrollRectIntoView(const WebCore::IntRect&, const WebCore::ScrollView*) const {}
    virtual void requestGeolocationPermissionForFrame(WebCore::Frame*, WebCore::Geolocation*);

private:
	HashMap<WebCore::String, WebCore::String> _uploadFileMap;
};

#endif /* ChromeClientSilk_h */

