///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "WebKitSilkPrefix.h"

#include "JSDOMWindow.h"
#include <runtime/JSLock.h>
#include "UString.h"
#include "PrototypeFunction.h"
#include "runtime/JSValue.h"
#include "runtime/FunctionConstructor.h"
#include "JSUtilityFunc.h"
#include "CEA2014ClientSilk.h"

// callback functions prototype
static JSC::JSValue JSC_HOST_CALL windowProtoFuncSetRenderMode(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist);
static JSC::JSValue JSC_HOST_CALL windowProtoFuncSubscribeToNotifications(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist);
static JSC::JSValue JSC_HOST_CALL windowProtoFuncDownload(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist);
static JSC::JSValue JSC_HOST_CALL windowProtoOpenURL(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist);
static JSC::JSValue JSC_HOST_CALL windowProtoRequestFocus(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist);
static JSC::JSValue JSC_HOST_CALL windowProtoSetHttpTimeout(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist);
static JSC::JSValue JSC_HOST_CALL windowProtoExitUnit(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist);

// property getter/setter prototype
static JSC::JSValue JSC_HOST_CALL maxHeightGetter(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList&);
static JSC::JSValue JSC_HOST_CALL maxWidthGetter(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList&);
static JSC::JSValue JSC_HOST_CALL topmostGetter(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList&);
static JSC::JSValue JSC_HOST_CALL httptimeoutGetter(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList&);
static JSC::JSValue JSC_HOST_CALL httptimeoutSetter(JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList&);

//
// Implemnts CEA2014 Javascript Interface to window
// 
void AddCEA2014JavascriptInterface(WebCore::JSDOMWindow* window)
{

#if 0
	return;
#else
	JSC::JSLock lock(false);
	if (window)
	{
		// Add the binding to JS environment
		JSC::ExecState* exec = window->globalExec();

		// Add CEA-2014 spec properties
		// 5.4.2 Window / UIContentFrame scripting object

		// properties
		/* a) */ addStaticProperty(window, JSC::Identifier(exec, "version"), JSC::jsString(exec, JSC::UString("CE-HTML")));
		/* b) */ addStaticProperty(window, JSC::Identifier(exec, "subversionNr"), JSC::jsString(exec, JSC::UString("1.0")));
		/* c) document */
		/* d) frames */
		/* e) innerHeight */
		/* f) innerWidth */
		/* g) location */
		/* h) history */
		/* i) id */
		/* j) name */
		/* k) onblur */
		/* l) onfocus */
		/* m) onblur */
		/* n) onkeyup */
		/* o) parent */
		/* p) top */
		/* q) */ addNativeHandlingProperty(window, JSC::Identifier(exec, "maxHeight"), maxHeightGetter, 0);
		/* r) */ addNativeHandlingProperty(window, JSC::Identifier(exec, "maxWidth"), maxWidthGetter, 0);
		/* s) */ addNativeHandlingProperty(window, JSC::Identifier(exec, "topmost"), topmostGetter, 0);
		/* t) */ addNativeHandlingProperty(window, JSC::Identifier(exec, "height"), maxHeightGetter, 0); // same as maxHeight
		/* u) */ addNativeHandlingProperty(window, JSC::Identifier(exec, "width"), maxWidthGetter, 0); // same as maxWidth
		/* v) */ addNativeHandlingProperty(window, JSC::Identifier(exec, "httptimeout"), 0, httptimeoutSetter);
				// TODO give me default timeout value.
				window->putDirect(JSC::Identifier(exec, "httptimeout"), JSC::jsNumber(exec, 10), 0); // set default

		// methods
		/* a) focus() */
		/* b) setTimeout() */
		/* c) clearTimeout() */
		/* d) */ addNativeFunction(window, JSC::Identifier(exec, "setRenderMode"), windowProtoFuncSetRenderMode);
		/* e) */ addNativeFunction(window, JSC::Identifier(exec, "subscribeToNotifications"), windowProtoFuncSubscribeToNotifications);
		/* f) */ addNativeFunction(window, JSC::Identifier(exec, "download"), windowProtoFuncDownload);
		/* g) */ addNativeFunction(window, JSC::Identifier(exec, "openURL"), windowProtoOpenURL);
		/* h) */ addNewFunction(window, JSC::Identifier(exec, "reload"), JSC::UString("window.location.reload();"));
		/* i) */ addNewFunction(window, JSC::Identifier(exec, "replace"), JSC::UString("window.location.replace(arguments[0]);"));
		/* j) */ addNativeFunction(window, JSC::Identifier(exec, "requestFocus"), windowProtoRequestFocus);
		/* k) */ addNativeFunction(window, JSC::Identifier(exec, "setHttpTimeout"), windowProtoSetHttpTimeout);
		/* l) */ addNewFunction(window, JSC::Identifier(exec, "setTimer"), JSC::UString("window.setTimeout(arguments[0], Number(arguments[1]) * 1000);"));
		/* m) */ addNewFunction(window, JSC::Identifier(exec, "clearTimer"), JSC::UString("window.clearTimeout(arguments[0]);"));
		/* n) */ addNewFunction(window, JSC::Identifier(exec, "getFrame"), JSC::UString("window.frames[arguments[0]];"));
		/* o) */ addNewFunction(window, JSC::Identifier(exec, "escapeBeyondTopmost"), JSC::UString("window.top.replace(arguments[0]);return(false);"));
		/* p) */ addNativeFunction(window, JSC::Identifier(exec, "exitUnit"), windowProtoExitUnit);

	}
#endif
}

//
// property getter/setter
//
#define ALIAS_GETTER(aliasName, origName) \
	static JSC::JSValue JSC_HOST_CALL aliasName##Getter( \
		JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList&) \
	{ \
		JSC::JSObject* thisObj = thisValue.toObject(exec); \
		if( thisObj ) \
		{ \
			return(thisObj->get(exec, JSC::Identifier(exec, "" # origName))); \
		} \
		return(JSC::jsUndefined()); \
	}

ALIAS_GETTER(maxHeight, innerHeight)
ALIAS_GETTER(maxWidth, innerWidth)
ALIAS_GETTER(topmost, top)


static JSC::JSValue JSC_HOST_CALL httptimeoutSetter(
	JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist)
{
	JSC::JSObject* thisObj = thisValue.toObject(exec);
	if( thisObj && !arglist.isEmpty() )
	{
		thisObj->putDirect(JSC::Identifier(exec, "httptimeout"), arglist.at(0).toJSNumber(exec), 0);

		double timeout = arglist.at(0).toNumber(exec);
		///////////////////////////
		// TODO set timeout
		///////////////////////////
	}
	return(JSC::jsUndefined());
}

//
// callbacks
//
static JSC::JSValue JSC_HOST_CALL windowProtoFuncSetRenderMode(
	JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist)
{
	JSC::JSObject* thisObj = thisValue.toObject(exec);
	if( thisObj && !arglist.isEmpty() )
	{
		JSC::UString str = arglist.at(0).toString(exec);
		if( str == JSC::UString("delayed") )
		{
			// TODO
		}
		else if( str == JSC::UString("default") )
		{
			// TODO
		}
		else
		{
			// ignored
		}
	}
	return(JSC::jsUndefined());
}

static JSC::JSValue JSC_HOST_CALL windowProtoFuncSubscribeToNotifications(
	JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist)
{
	// TODO
	return(JSC::jsUndefined());
}

static JSC::JSValue JSC_HOST_CALL windowProtoFuncDownload(
	JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist)
{
	// TODO
	return(JSC::jsUndefined());
}

static JSC::JSValue JSC_HOST_CALL windowProtoOpenURL(
	JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist)
{
	// TODO
	return(JSC::jsUndefined());
}

static JSC::JSValue JSC_HOST_CALL windowProtoRequestFocus(
	JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist)
{
	// TODO
	return(JSC::jsUndefined());
}

static JSC::JSValue JSC_HOST_CALL windowProtoSetHttpTimeout(
	JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist)
{
	// TODO
	return(JSC::jsUndefined());
}

static JSC::JSValue JSC_HOST_CALL windowProtoExitUnit(
	JSC::ExecState* exec, JSC::JSObject* obj, JSC::JSValue thisValue, const JSC::ArgList& arglist)
{
	// TODO
	return(JSC::jsUndefined());
}

