///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef CEWebKitUtility_h
#define CEWebKitUtility_h

#ifdef HAVE_FLOAT_H
#undef HAVE_FLOAT_H
#endif

#ifdef HAVE_STDINT_H
#undef HAVE_STDINT_H
#endif

#ifdef HAVE_STDLIB_H
#undef HAVE_STDLIB_H
#endif

#include "ICEUString.h"

class CEWebKitUtility
{
public:
	static CEHResult convert(ICEUString* sString, WebCore::String*& wString)
	{
		CEHResult hr = CE_S_OK;
		if (sString)
		{
			wString = new WebCore::String;
			if (wString)
			{
				hr = wString->fromICEUString(sString);
			}
			else
			{
				hr = CE_SILK_ERR_MEMERR;
			}
		}
		else
		{
			wString = NULL;
			hr = CE_S_OK;
		}
		return hr;
	}
};

#endif /* CEWebKitUtility_h */
