///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////

#ifndef CEWebKitSettingsImpl_h
#define CEWebKitSettingsImpl_h

#include <ICEHtmlWebKit.h>
#include <Settings.h>

class CEWebKitSettingsImpl
{
public:
	CEWebKitSettingsImpl(WebCore::Settings* settings);

	// ICEWebKitSettings
	CEHResult setJavaScriptEnabled(bool enabled);
	CEHResult isJavaScriptEnabled(bool* enabledOut);
	CEHResult userStyleSheetLocation(ICEURL** locationOut);
	CEHResult setUserStyleSheetLocation(ICEURL* location);
	CEHResult setCEA2014ModeEnabled(bool enabled);
	CEHResult isCEA2014ModeEnabled(bool* enabledOut);
	CEHResult setDefaultFontSize(UINT32 size);
	CEHResult setDefaultFixedFontSize(UINT32 size);
	CEHResult setAcceleratedCompositingEnabled(bool enabled);
	CEHResult acceleratedCompositingEnabled(bool* enabledOut);
	CEHResult setPluginEnabled(bool enabled);

private:
	WebCore::Settings* _settings;
    bool bCEA2014Mode;
};

#endif /* CEWebKitSettingsImpl_h */
