///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009,2010 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef CEWebKitFrameWindowImpl_h
#define CEWebKitFrameWindowImpl_h

#include "CESysDefs.h"
#include "Page.h"
#include "DragData.h"
#include "KeyboardEvent.h"
#include "ScrollTypes.h"

#include "ICEHtmlWebKit.h"
#include "ResourceHandleInternal.h"
#include "ResourceHandleManagerCore.h"

#if USE(ACCELERATED_COMPOSITING)
#include "GraphicsLayerSilk.h"
#include "CEWebKitAccComp.h"
#endif //#if USE(ACCELERATED_COMPOSITING)

#include "ICETextSupport.h"
#include "FloatRect.h"

namespace WebCore {
	class FrameView;
	class RenderObject;
	class Widget;
}

class CEWebKitWindow;
class CEWebKitFrameWindowPrivate;
struct ICEUString;

class CEWebKitFocusContext;

class CEWebKitFrameWindowImpl
{
public:
	CEWebKitFrameWindowImpl();
	~CEWebKitFrameWindowImpl();

	// The implement of ICEWebKitFrameWindow
	CEHResult init(ICEHtmlWebKitFrameWindowWidget* iWidget, ICEHtmlWebKitFrameWindowChromeClient* iChromeClient, ICEHtmlFocusNavigator* iFocusNavigator);
	CEHResult shutdown();
	CEHResult load(ICEUString* iUrl, ICEUString* iReferer);
	CEHResult paint(ICEVGContext* iVGC, CERect* dirtyRect);
	CEHResult mouse(CEMouseEventParam* mouseEventParam, bool* consumedOut);
	CEHResult keyboard(CEKeyboardEventParam* keyboardEventParam, bool* consumedOut);
	CEHResult back(UINT32 amount);
	CEHResult forward(UINT32 amount);
	CEHResult focus(bool focused);
	CEHResult reload(bool skipCache);
	CEHResult hitTest(INT32 x, INT32 y, ICEURL** linkUrlOut, ICEURL** imageUrlOut, ICEUString** text, CERect* zoomRect);
	CEHResult insertText(ICEUString* iString, CEUUINT32List* styleList, CEUUINT32List* lengthList, INT32 caretPosition, bool* consumedOut);
	CEHResult endComposition();
	CEHResult clearText();
	CEHResult exitIME();
	CEHResult setSelectedItemsPopupMenu(INT32 selectedIndex, void *client);
	CEHResult shrinkHistory(UINT32 minimumSize);
	CEHResult scroll(INT32 x, INT32 y, INT32 dx, INT32 dy, UINT32 modifiers, bool* consumedOut);
	CEHResult resize(INT32 width, INT32 height);
	CEHResult setCustomTextEncodingName(ICEUString* iTitle);
	CEHResult getSettings(ICEWebKitSettings** iSettingsOut);
	CEHResult stop();
	CEHResult emptyPage();
	CEHResult isEmpty(bool* isEmptyOut);
	CEHResult setAllowsScrolling(bool visible);
	CEHResult getContentsSize(INT32* widthOut, INT32* heightOut);
	CEHResult setVisibleRect(INT32 x, INT32 y, INT32 width, INT32 height);
	CEHResult confirmPlugin(bool result, bool keepResult, void *const cData);
	CEHResult replyNetworkLibraryError(bool result, ICEUString* errorPageStr);
	CEHResult setHitTestPadding(INT32 docPadding);
	CEHResult changeZoomFactor(float scale);
	CEHResult getElementUrl(void* hView, ICEURL** anchorUrlOut) const;
	CEHResult getElementRect(void* hView, CERect* rectOut);
	CEHResult isDocumentCoordinateMode(bool* resultOut);
	CEHResult windowRectToContentsRect(const CERect* windowRect, CERect* contentRectOut);
	CEHResult contentsRectToWindowRect(const CERect* contentRect, CERect* windowRectOut);
	CEHResult windowPointToContentsPoint(const CEPointBase* windowPos, CEPointBase* contentPosOut);
	CEHResult contentsPointToWindowPoint(const CEPointBase* contentPos, CEPointBase* windowPosOut);
	//

	// call ResourceHandleManager's callback
	CEHResult didReceiveResponseCallback(const void* webCoreJob, const char* responseHeaderBuffer, UINT32 responseHeaderSize, const char* url, UINT32 httpCode, UINT32 expectedContentLength, bool noContext, bool syncRequest, UINT32 sslErr);
	CEHResult didReceiveDataCallback(const void* webCoreJob, UINT32 httpCode, const char* url, const void* data, UINT32 size, bool syncRequest);
	CEHResult didFinishLoadingCallback(const void* webCoreJob, bool syncRequest);
	CEHResult didFinishLoadingAllInOneCallback(const void* webCoreJob, const char* responseHeaderBuffer, UINT32 responseHeaderSize, const char* url, UINT32 httpCode, UINT32 expectedContentLength, bool noContext, const void* data, UINT32 size, bool syncRequest);
	CEHResult willSendRequestCallback(const void* webCoreJob, const char* url, bool syncRequest);
	CEHResult didFailCallback(const void* webCoreJob, INT32 lowLevelError, CEHResult resultCode, bool noContext, bool syncRequest);
	CEHResult replyBadCertCallback(unsigned long identifier, bool sslContinue);
	CEHResult replyAuthCallback(unsigned long identifier, ICEUString* site, ICEUString* realm, ICEUString* username, ICEUString* password, bool authContinue, bool updateSavedFlag);
	CEHResult setCertificate(const void* webCoreJob, void* cert);

	CEHResult setPageSizeMultiplier(float multiplier);
	CEHResult getPageSizeMultiplier(float *const multiplierOut);
	CEHResult canZoomPageIn(bool *const resultOut);
	CEHResult zoomPageIn();
	CEHResult canZoomPageOut(bool *const resultOut);
	CEHResult zoomPageOut();
	CEHResult canResetPageZoom(bool *const resultOut);
	CEHResult resetPageZoom();
	CEHResult getZoomTextOnly(bool *const resultOut);
	CEHResult setZoomTextOnly(bool bZoomTextOnly);
	CEHResult getPage(void** newPageOut);

	CEWebKitFrameWindowPrivate* getPrivate() { return _private; }

	CEComICEHtmlWebKitFrameWindowWidgetRef& getWidget() { return _iWidgetRef; }
	CEComICEHtmlWebKitFrameWindowChromeClientRef& getChromeClient() { return _iChromeClientRef; }
	CEComICEHtmlWebKitFrameWindowLoaderClientRef& getLoaderClient() { return _iLoaderClientRef; }

	bool handleEditingKeyboardEvent(WebCore::KeyboardEvent* evt);
    void updateInputMethodState();
    void inactivateInputMethodState(bool nextIsUseInputMethod);

	CEHResult getDeviceScreenRect(CERect *const deviceScreenRectOut);
	CEHResult setScrollPosition(INT32 x, INT32 y);
	CEHResult notifyChangeContentSize(INT32 width, INT32 height, INT32 fixedLayoutWidth, INT32 fixedLayoutHeight, float zoomFactor);
	CEHResult getWebKitWidget(CEWebKitWidget* *const ceWebKitWidgetOut);
	CEHResult initializeIME(bool password, bool singleLine, CEWebKitWidgetInputType inputType, const unsigned char* defaultStringStrUTF8, unsigned int defaultStringLen, INT32 maxLength, INT32 imeRect_x, INT32 imeRect_y, INT32 imeRect_width, INT32 imeRect_height, bool isPlugin, WebCore::Widget* pTarget);
	CEHResult shutdownIME(bool nextIsTextInput);
	CEHResult getUpdateDocRect(WebCore::FloatRect* const updateRect);
	float getZoomFactor();
	CEHResult repaint(const WebCore::IntRect& rect);
	CEHResult getScrollMode(CEWebKitScrollMode *const scrollMode);
	////////////////////////////////////////
	// ICEWebKitCopyPasteEventListener
	////////////////////////////////////////
	CEHResult handleCopyEvent();
	CEHResult handlePasteEvent();	// Reserved.

private:
	CEHResult _privateInit();
	CEHResult _privateShutdown();
	CEHResult _focusInit(ICEHtmlFocusNavigator* iFocusNavigator);
	CEHResult _focusShutdown();

	CEHResult _mouse(eCEMouseEventType type, CEPointBase& pt, eCEMouseButton button, UINT32 modifiers, bool& consumedOut);
	CEHResult _drag(CEPointBase& pt);
	CEHResult _scroll(INT32 x, INT32 y, INT32 dx, INT32 dy, UINT32 modifiers, bool& consumedOut);
	bool _isDocumentCoordinateMode();
	CEHResult _mouseLButtonUpRepeatJudging(CEPointBase& pt, UINT32 modifiers, bool& consumedOut);
	CEHResult _hitTestResult(INT32 x, INT32 y, WebCore::HitTestResult& resultOut);
	CEHResult _getElementRect(WebCore::Node* node, CERect* rectOut);

private:
	CEComICEHtmlWebKitFrameWindowWidgetRef _iWidgetRef;
	CEComICEHtmlWebKitFrameWindowChromeClientRef _iChromeClientRef;
	CEComICEHtmlWebKitFrameWindowLoaderClientRef _iLoaderClientRef;
	CEComICEHtmlFocusNavigatorPeerRef _iFocusNavigatorPeerRef;
	CEWebKitFrameWindowPrivate* _private;
	CEWebKitWindow* _mainWindow;
	bool _hasInitializedTextInput;
	bool _lockingOutForMemoryLimit;
	bool _skipNotifyScrollPosition;
	INT32 _hitTestPadding;
	WebCore::Widget* _imeTargetPlugin;
	bool _isFocusNodeChanged_Mouse;
	WebCore::Node* _focusedTextInputNode;
	WebCore::IntRect _defaultFrameSize;

	/*
	 * Focus Navigation
	 */
public:
	void rebuildFocusNavigation();
};

class CEWebKitFrameWindowPrivate
{
public:
	CEWebKitFrameWindowPrivate(CEWebKitFrameWindowImpl* silkPeer);

	CEHResult init(CEWebKitWindow*& mainWindow);
	CEHResult shutdown(CEWebKitWindow*& mainWindow);
	CEHResult drag(WebCore::DragData& data);

	WebCore::Page* getPage() { return _page; }
	void getScrollbarMode(WebCore::ScrollbarMode& horizontalMode, WebCore::ScrollbarMode& verticalMode) const
	{
		horizontalMode = _scroll_mode_h;
		verticalMode = _scroll_mode_v;
	}

#if USE(ACCELERATED_COMPOSITING)
	// on the other platform, the followings are defined in WebView.h.
	void layerSetRootGraphicsLayer(ICEMRLLayer* nativeRootLayer);
	void layerMarkForSync(bool b);
	CEHResult renderLayerBackingStore(ICEVGContext* iVGC, CERectF* dirtyRect);
	bool hasExceptForLayersBackingStore()const;
	void invalidateExceptForLayersBackingStore();
#endif //#if USE(ACCELERATED_COMPOSITING)

private:
	CEHResult _initPage();
	CEHResult _initMainFrame(CEWebKitWindow*& mainWindow);
	CEHResult _shutdownPage();
	CEHResult _shutdownMainFrame(CEWebKitWindow*& mainWindow);
	CEHResult _initScrollMode();

private:
	CEWebKitFrameWindowImpl* _silkPeer;
	WebCore::Page* _page;
	WebCore::ScrollbarMode _scroll_mode_h;
	WebCore::ScrollbarMode _scroll_mode_v;
#if USE(ACCELERATED_COMPOSITING)	
	CEComICEMRLLayerRef _rootLayer;
	CEWebKitAccCompSyncTimer _syncTimer;
	CEComICEVGSurfaceRef _exceptForLayersBackingStore;
	CEComICEMRLLayerRendererRef _renderer;
#endif //#if USE(ACCELERATED_COMPOSITING)
};

CEWebKitFrameWindowImpl* kit(WebCore::Page* page);
WebCore::Page* core(CEWebKitFrameWindowImpl* frameWindow);

#endif /* CEWebKitFrameWindowImpl_h */
