/*
 * Copyright (C) 2006, 2007, 2008, 2009 Apple Inc. All rights reserved.
 * Copyright     2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CEWebKitDocumentLoader_h_
#define _CEWebKitDocumentLoader_h_

#include "DocumentLoader.h"
#include "ICEHtmlWebKit.h"


class CEWebKitDocumentLoader : public WebCore::DocumentLoader 
{
public:
    static PassRefPtr<CEWebKitDocumentLoader> create(const WebCore::ResourceRequest& request, const WebCore::SubstituteData& data)
    {
        return adoptRef(new CEWebKitDocumentLoader(request, data));
    }

	void setDocumentLoaderClient(ICEHtmlWebKitDocumentLoaderClient* iDocumentLoaderClient) { _iDocumentLoaderClientRef = iDocumentLoaderClient; }
	CEComICEHtmlWebKitDocumentLoaderClientRef getDocumentLoaderClient() { return _iDocumentLoaderClientRef; }

private:
	CEWebKitDocumentLoader(const WebCore::ResourceRequest& requset, const WebCore::SubstituteData& substituteData);

    virtual ~CEWebKitDocumentLoader();

    virtual void attachToFrame();
    virtual void detachFromFrame();

private:
	CEComICEHtmlWebKitDocumentLoaderClientRef _iDocumentLoaderClientRef;

};

#endif /* _CEWebKitDocumentLoader_h_ */
