///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "WebKitSilkPrefix.h"

#include "CEWebKitClassFactoryImpl.h"
#include "CEWebKit.h"

CEHResult CEWebKitClassFactoryImpl::createInstance(ICEUnknown* pUnkOuter, UINT32 iid, void** ppv)
{
	CEHResult hr = CE_SILK_ERR_BADARGS;
	if ( getClsid() == CEComClassID_CEWebKit && iid == CEComIID_ICEWebKit )
	{
		hr = CE_SILK_ERR_MEMERR;
		CEWebKit* webKit = new CEWebKit();
		if (webKit)
		{
			CEComICEWebKitRef iWebKitRef = CEWebKit::toICEWebKit(webKit);
			*ppv = iWebKitRef.detach();
			hr = CE_S_OK;
		}
	}
	return hr;
}
