///////////////////////////////////////////////////////////////////////////////
// Copyright 2010 Sony Corporation
///////////////////////////////////////////////////////////////////////////////
#ifndef CEWebKitAccComp_h
#define CEWebKitAccComp_h

class CEWebKitFrameWindowPrivate;
class CEWebKitFrameWindowImpl;

#if USE(ACCELERATED_COMPOSITING)

#include "Timer.h"

class CEWebKitAccCompSyncTimer: Noncopyable {
public:
	CEWebKitAccCompSyncTimer(CEWebKitFrameWindowPrivate*);
	~CEWebKitAccCompSyncTimer();
	void startOneShot();

private:
	void syncTimerFired(WebCore::Timer<CEWebKitAccCompSyncTimer>*);
	WebCore::Timer<CEWebKitAccCompSyncTimer> _syncTimer;
	CEWebKitFrameWindowPrivate* _pWebViewPrivate;
};

#define CEMRL_FPS_18278

#if defined(CEMRL_FPS_18278)
namespace CEMRLFPS_18278
{
	void saveTime(size_t ci, size_t idx);
	void print(ICEVGContext* out, const char* mode);
	void shutdown();
};

#define CEMRL_FPS_18278_SAVETIME(_ci, _idx) CEMRLFPS_18278::saveTime(_ci, _idx)
#define CEMRL_FPS_18278_PRINT(_out, _mode) CEMRLFPS_18278::print(_out, _mode)
#define CEMRL_FPS_18278_SHUTDOWN CEMRLFPS_18278::shutdown()

#else //#if defined(CEMRL_FPS_18278)

#define CEMRL_FPS_18278_SAVETIME(_ci, _idx)
#define CEMRL_FPS_18278_PRINT(_out, _mode)
#define CEMRL_FPS_18278_SHUTDOWN

#endif //#if defined(CEMRL_FPS_18278)

#endif //#if USE(ACCELERATED_COMPOSITING)

class CEWebKitMRLWindowImpl
{
public:
	CEWebKitMRLWindowImpl(CEWebKitFrameWindowImpl* fw)
		: _fw(fw)
	{}

	CEHResult invalidateRect(INT32 x, INT32 y, INT32 width, INT32 height);
	CEHResult invalidate();

private:
	CEWebKitFrameWindowImpl* _fw;
};


#endif //#ifndef CEWebKitAccComp_h
