///////////////////////////////////////////////////////////////////////////////
// Copyright 2010 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef _NPAPI_SILK_H_
#define _NPAPI_SILK_H_

#include "npapi.h"
#include "npfunctions.h"

#define CENP_WM_BASE                     (0x400 + 0x100)
#define CENP_WM_PAINT                    (CENP_WM_BASE + 0x01)
#define CENP_WM_TIMER                    (CENP_WM_BASE + 0x02)
#define CENP_WM_MOUSEMOVE                (CENP_WM_BASE + 0x20)
#define CENP_WM_LBUTTONDOWN              (CENP_WM_BASE + 0x21)
#define CENP_WM_LBUTTONUP                (CENP_WM_BASE + 0x22)
#define CENP_WM_RBUTTONDOWN              (CENP_WM_BASE + 0x24)
#define CENP_WM_RBUTTONUP                (CENP_WM_BASE + 0x25)
#define CENP_WM_KEYDOWN                  (CENP_WM_BASE + 0x30)
#define CENP_WM_KEYUP                    (CENP_WM_BASE + 0x31)
#define CENP_WM_IME_COMPOSITIONTEXT      (CENP_WM_BASE + 0x40)
#define CENP_WM_IME_ENDCOMPOSITION       (CENP_WM_BASE + 0x41)
#define CENP_WM_IME_CLEARCOMPONENTTEXT   (CENP_WM_BASE + 0x42)
#define CENP_WM_IME_EXITCOMPONENT        (CENP_WM_BASE + 0x43)

typedef struct _CENPRect
{
	int _left;
	int _right;
	int _top;
	int _bottom;
	
} CENPRect;

typedef struct 
{
	int pitch;
	int bytePerPixel;
	unsigned char* pbuffer;
} CENPBuffer;

typedef struct
{
	NP_InitializeFuncPtr			NP_Initialize;
#if !defined(_MSC_VER)
	NP_GetMIMEDescriptionFuncPtr	NP_GetMIMEDescription;
#endif
} CENPExportedCallbacks;

typedef struct _CENPPoint
{
	int _x;
	int _y;
} CENPPoint;

/*!
 * IME mode is defined as follows:
 */
typedef enum
{
	CENPImeModeFlag_Password		= 1 << 6,		//!< Password
	CENPImeModeFlag_SingleLine		= 1 << 7,		//!< Single line

	CENPImeModeFlag_Type_Undefined	= 0 << 8,		//!< Unknown type
	CENPImeModeFlag_Type_Text		= 1 << 8,		//!< type=text
	CENPImeModeFlag_Type_Search		= 2 << 8,		//!< type=search
	CENPImeModeFlag_Type_Tel		= 3 << 8,		//!< type=tel
	CENPImeModeFlag_Type_Url		= 4 << 8,		//!< type=url
	CENPImeModeFlag_Type_Email		= 5 << 8,		//!< type=email
	CENPImeModeFlag_Type_Password 	= 6 << 8,		//!< type=password
	CENPImeModeFlag_Type_Number		= 7 << 8,		//!< type=number
	CENPImeModeFlag_Type_Mask		= 0xff << 8,	//!< Mask of CENPImeModeFlag_Type
} CENPImeModeFlag;

typedef struct _CENPInitializeIME
{
	unsigned char* iDefaultStringStr;	/* The default string to setting for IME (UTF8), it hasn't NULL terminate.*/
	unsigned int iDefaultStringLen;		/* The Byte length of iDefaultStringStr */
	int maxLength;						/* The maxium character length of inputting text*/
	unsigned int imeMode;				/* IME Mode setting to use CENPImeModeFlag.*/
} CENPInitializeIME;

typedef struct _CENPSetCompositionText
{
	unsigned char* iTextStr;			/* The string to be inputted from IME (UTF8), it hasn't NULL terminate.*/
	unsigned int iTextLen;				/* The Byte length of iTexStr*/
} CENPSetCompositionText;

#endif


