///////////////////////////////////////////////////////////////////////////////
// Copyright     2011 Sony Corporation
// Copyright (C) 2011 Sony Computer Entertainment Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////

#include "config.h"
#include "FileSystem.h"

#include "ICEPluginSharedObjectLoader.h"
#include "npfunctions.h"

namespace WebCore {

typedef EXPORTED_CALLBACK(NPError, NP_InitializeFuncPtrUnix)(NPNetscapeFuncs*, NPPluginFuncs*);
CEHResult initializePluginSilk(CEComICEPluginModuleLoaderRef iModuleLoaderRef, PlatformModule module, NPNetscapeFuncs* browserFuncs, NPPluginFuncs* pluginFuncs)
{
    const char* NPInitializeFuncName = "NP_Initialize";
    NP_InitializeFuncPtrUnix NP_Initialize = 0;
    CEHResult hr = iModuleLoaderRef.findSymbol(module, NPInitializeFuncName, sizeof(NPInitializeFuncName), reinterpret_cast<void**>(&NP_Initialize));
    if (CESucceeded(hr))
    {
        NPError npErr = NP_Initialize(browserFuncs, pluginFuncs);
        if (npErr != NPERR_NO_ERROR)
        {
            hr = CE_SILK_ERR_OPERATION_FAILED;
        }
    }
    return hr;
}

} // namespace WebCore

