/*
 * Copyright (C) 2008 Apple Inc. All Rights Reserved.
 * Copyright     2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef ScrollbarThemeSilk_h
#define ScrollbarThemeSilk_h

#include "ScrollbarTheme.h"
#include "ICEHtmlWebKit.h"

namespace WebCore {

	class ScrollbarThemeSilk: public ScrollbarTheme
	{
	public:
		ScrollbarThemeSilk();
		virtual ~ScrollbarThemeSilk() {}

		virtual bool paint(Scrollbar* scrollbar , GraphicsContext* gc, const IntRect& damageRect);
		virtual ScrollbarPart hitTest(Scrollbar* scrollbar, const PlatformMouseEvent& mouseEvent);
		virtual int scrollbarThickness(ScrollbarControlSize = RegularScrollbar);
		virtual void invalidatePart(Scrollbar* scrollbar, ScrollbarPart part);

		virtual int thumbPosition(Scrollbar* scrollbar);
		virtual int thumbLength(Scrollbar* scrollbar);
		virtual int trackPosition(Scrollbar* scrollbar);
		virtual int trackLength(Scrollbar* scrollbar);

		virtual void registerScrollbar(Scrollbar* scrollbar);
		virtual void unregisterScrollbar(Scrollbar* scrollbar);
		void setZoomFactor(float zoomFactorValue) { m_zoomFactorValue=zoomFactorValue; };

	private:
		CEComICEHtmlWebKitThemeRef _iWebKitThemeRef;
		float m_zoomFactorValue;
	};

} // namespace WebCore

#endif /* ScrollbarThemeSilk_h */
