///////////////////////////////////////////////////////////////////////////////
// Copyright 2008 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "config.h"
#include "IntRect.h"
#include "PlatformScreen.h"
#include "HostWindow.h"
#include "ScrollView.h"
#include "Widget.h"
#include "NotImplemented.h"

namespace WebCore {

int screenDepth(Widget* widget)
{
    notImplemented();
    return 0;
}

int screenDepthPerComponent(Widget* widget)
{
    notImplemented();
    return 0;
}

bool screenIsMonochrome(Widget* widget)
{
    notImplemented();
    return false;
}

FloatRect screenRect(Widget* widget)
{
	FloatRect screenRect(FloatPoint(0.0f, 0.0f),FloatSize(0.0f, 0.0f));
	if(widget)
	{
		if (widget->root() && widget->root()->hostWindow())
		{
			PlatformWidget silkWidget =  widget->root()->hostWindow()->platformWindow();
			if(silkWidget)
			{
				IntRect deviceScreenRect;
				CEHResult err = silkWidget->getDeviceScreenRect(&deviceScreenRect);
				if(!err)
				{
				    screenRect.setSize(FloatSize(deviceScreenRect.width(), deviceScreenRect.height()));
				}
			}
		}
	}
    return screenRect;
}

FloatRect screenAvailableRect(Widget* widget)
{
	//for Bug 17003.
	//SilkCore allows huge-size!
	FloatRect wk_fr(0.0, 0.0, static_cast<float>(INT_MAX), static_cast<float>(INT_MAX));
    return wk_fr;
}

} // namespace WebCore
