///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "config.h"
#include "Language.h"
#include "PlatformString.h"
#include "ICEHtmlWebKit.h"

namespace WebCore {

String defaultLanguage()
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	
	CEComICEHtmlWebKitDeviceInfoRef iwebkitDeviceInfoRef=0;
	CEComGetThreadContext(CEComIID_ICEHtmlWebKitDeviceInfo, reinterpret_cast<void**>(&iwebkitDeviceInfoRef));

	if(iwebkitDeviceInfoRef)
	{
		CEComICEUStringRef sAcceptLanguage=0;
		hr = iwebkitDeviceInfoRef.getAcceptLanguage(&sAcceptLanguage);
		if(CESucceeded(hr))
		{
			WebCore::String wAcceptLanguage;
			hr = wAcceptLanguage.fromICEUString(sAcceptLanguage);
			if(CESucceeded(hr))
			{
				if (wAcceptLanguage.length() > 0)
				{
					UChar delimiter = ',';
					return wAcceptLanguage.substring(0, wAcceptLanguage.find(delimiter));
				}
				else
				{
					hr = CE_SILK_ERR_INVALID_CHAR;
				}
			}
		}
	}

	return "en";
}

}

