///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "config.h"

#include "CESysDefs.h"
#include "CEUITypes.h"

#include "PlatformKeyboardEvent.h"

//#include "NotImplemented.h"

namespace WebCore {

static PlatformKeyboardEvent::Type cnvType(eCEKeyboardEventType type)
{
	PlatformKeyboardEvent::Type ret;

	switch (type)
	{
		case eCEKeyboardEventType_KeyDown:		ret = PlatformKeyboardEvent::RawKeyDown; break;
		case eCEKeyboardEventType_KeyUp:		ret = PlatformKeyboardEvent::KeyUp; break;
		default: ret = PlatformKeyboardEvent::Char; break;
	}
	
	return ret;
}
	
static inline String singleCharacterString(UChar c) { return String(&c, 1); }

PlatformKeyboardEvent::PlatformKeyboardEvent(CEKeyboardEventParam* ev)
    : m_type(cnvType(ev->type))
    , m_text((ev->type == eCEKeyboardEventType_KeyTyped) ? singleCharacterString(ev->keyChar) : String())
    , m_unmodifiedText((ev->type == eCEKeyboardEventType_KeyTyped) ? singleCharacterString(ev->keyChar) : String())
    , m_keyIdentifier(String())
    , m_autoRepeat(false)
    , m_windowsVirtualKeyCode(static_cast<int>(ev->virtualKey))
    , m_nativeVirtualKeyCode(m_windowsVirtualKeyCode)
    , m_isKeypad(false)
    , m_shiftKey((eCEKeyModifier_SHIFT & ev->modifiers))
    , m_ctrlKey((eCEKeyModifier_CTRL & ev->modifiers))
    , m_altKey((eCEKeyModifier_ALT & ev->modifiers))
    , m_metaKey(false)
{
}

	
void PlatformKeyboardEvent::disambiguateKeyDownEvent(Type type, bool backwardCompatibilityMode)
{
	//   notImplemented();
}

bool PlatformKeyboardEvent::currentCapsLockState()
{
    //notImplemented();
    return false;
}

}
