/*
 * Copyright 2009 Sony Corporation
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "config.h"
#include "ClipboardSilk.h"

#include "FileList.h"
#include "NotImplemented.h"
#include "StringHash.h"

#include "Editor.h"

namespace WebCore {

PassRefPtr<Clipboard> Editor::newGeneralClipboard(ClipboardAccessPolicy policy)
{
    return ClipboardSilk::create(policy, false);
}

ClipboardSilk::ClipboardSilk(ClipboardAccessPolicy policy, bool forDragging)
    : Clipboard(policy, forDragging)
{
    notImplemented();
}

ClipboardSilk::~ClipboardSilk()
{
    notImplemented();
}

void ClipboardSilk::clearData(const String& str)
{
    _privateClipboard = str;
}

void ClipboardSilk::clearAllData()
{
    _privateClipboard = "";
}

String ClipboardSilk::getData(const String& str, bool &success) const
{
    success = _privateClipboard.length() > 0;
    return _privateClipboard;
}

bool ClipboardSilk::setData(const String& str, const String&)
{
    _privateClipboard = str;
    return true;
}

HashSet<String> ClipboardSilk::types() const
{
    HashSet<String> results; 
	results.add("Text");
	results.add("text/plain");
    return results;
}

PassRefPtr<FileList> ClipboardSilk::files() const
{
    return 0;
}

IntPoint ClipboardSilk::dragLocation() const
{
    notImplemented();
    return IntPoint(0, 0);
}

CachedImage* ClipboardSilk::dragImage() const
{
    notImplemented();
    return 0;
}

void ClipboardSilk::setDragImage(CachedImage*, const IntPoint&)
{
    notImplemented();
}

Node* ClipboardSilk::dragImageElement()
{
    notImplemented();
    return 0;
}

void ClipboardSilk::setDragImageElement(Node*, const IntPoint&)
{
    notImplemented();
}

DragImageRef ClipboardSilk::createDragImage(IntPoint&) const
{
    notImplemented();
    return 0;
}

void ClipboardSilk::declareAndWriteDragImage(Element*, const KURL&, const String&, Frame*)
{
    notImplemented();
}

void ClipboardSilk::writeURL(const KURL&, const String&, Frame*)
{
    notImplemented();
}

void ClipboardSilk::writeRange(Range*, Frame*)
{
    notImplemented();
}

bool ClipboardSilk::hasData()
{
    notImplemented();
    return false;
}

}
