/*
 * Copyright (C) 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright     2011 Sony Corporation
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef ResourceError_h
#define ResourceError_h

#include "ResourceErrorBase.h"

namespace WebCore {

class ResourceError : public ResourceErrorBase
{
public:
    ResourceError()
		: ResourceErrorBase()
		, m_resultCode(CE_S_OK)
		, m_internalErrorCode(CE_S_OK)
		, m_lowLevelErrorCode(0)
		, m_noContext(false)
		, m_isMainResource(false)
    {
    }

    ResourceError(const String& domain, int errorCode, const String& failingURL, const String& localizedDescription)
        : ResourceErrorBase(domain, errorCode, failingURL, localizedDescription)
	, m_resultCode(CE_S_OK)
	, m_internalErrorCode(CE_S_OK)
	, m_lowLevelErrorCode(0)
	, m_noContext(false)
	, m_isMainResource(false)
    {
    }

    ResourceError(const String& domain, int errorCode, const String& failingURL, const String& localizedDescription, CEHResult resultCode, CEHResult internalErrCode, int lowLevelErrorCode)
        : ResourceErrorBase(domain, errorCode, failingURL, localizedDescription)
	, m_resultCode(resultCode)
	, m_internalErrorCode(internalErrCode)
	, m_lowLevelErrorCode(lowLevelErrorCode)
	, m_noContext(false)
	, m_isMainResource(false)
    {
    }

	CEHResult resultCode() const { return m_resultCode; }
	CEHResult internalErrorCode() const { return m_internalErrorCode; }
	int lowLevelErrorCode() const { return m_lowLevelErrorCode; }

    void setNoContext(bool noContext) { m_noContext = noContext; }
    bool noContext() const { return m_noContext; }

	void setIsMainResource() const { m_isMainResource = true; }
	bool getIsMainRresource() const { return m_isMainResource; }

private:
	CEHResult m_resultCode;
	CEHResult m_internalErrorCode;
	int m_lowLevelErrorCode;
	bool m_noContext;

	mutable bool m_isMainResource;
};

}

#endif // ResourceError_h_
