/*
 * Copyright (C) 2006, 2007, 2008 Apple Inc.  All rights reserved.
 * Copyright 2008, 2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#if USE(SILK_CEUIFONT)
#include "SimpleFontData.h"

#include "Font.h"
#include "FontCache.h"
#include "FloatRect.h"
#include "FontDescription.h"
#include <wtf/MathExtras.h>
#include <unicode/uchar.h>
#include <unicode/unorm.h>

#include "ICEPFRasterizer.h"

namespace WebCore {
const float cSmallCapsFontSizeMultiplier = 0.7f;
static bool g_shouldApplyMacAscentHack;

SimpleFontData* SimpleFontData::smallCapsFontData(const FontDescription& fontDescription) const
{
	if (!m_smallCapsFontData) {
		float smallCapsHeight = cSmallCapsFontSizeMultiplier * platformData().size();
		CEU_UNUSED(smallCapsHeight);

		CEComICEUIPlatformFontRef pfFont;
		CEComICEUIPlatformFontRef pfBase = platformData().pfFont();
		pfBase.getSmallCapsFont(&pfFont);
		INT32 smallCapsFontSize = 0;
		pfFont.getValue(CEUIFontValueType_PixelSize, &smallCapsFontSize);

		bool synthesizeBold = platformData().syntheticBold();
		bool synthesizeItalic = platformData().syntheticOblique();
		FontPlatformData scFontData(pfFont, smallCapsFontSize, synthesizeBold, synthesizeItalic);
		m_smallCapsFontData = new SimpleFontData(scFontData);
	}
	return m_smallCapsFontData;
}

void SimpleFontData::determinePitch()
{
	if (isCustomFont()) {
		m_treatAsFixedPitch = false;
		return;
	}

	bool isPf = false;
	CEComICEUIPlatformFontRef f = platformData().pfFont();
	if (f) {
		CEPFFaceInfo pfinfo;
		f.getFaceInfo(&pfinfo);
		m_treatAsFixedPitch = !(pfinfo.isScalable);
	} else {
		CEASSERT(0 && "fix this error");
		m_treatAsFixedPitch = false;
	}
}

bool SimpleFontData::containsCharacters(const UChar* characters, int length) const
{
	// FIXME: Support custom fonts.
	if (isCustomFont())
		return false;

	ASSERT(0 && "fix this");
	bool ret = false;
	bool isPf = false;
	CEComICEUIPlatformFontRef f = platformData().pfFont();
	if (f)
		ret = (f.getGlyphs16((const UTF16CHAR*)characters, length, true, 0, 0) == CE_S_OK);
	return ret;
}
}; // namespace WebCore

#else //#if !USE(SILK_CEUIFONT)
bad config.
#endif //#if !USE(SILK_CEUIFONT)
