///////////////////////////////////////////////////////////////////////////////
// Copyright 2010 Sony Corporation
///////////////////////////////////////////////////////////////////////////////
#ifndef __CEGLAYERCALLBACKIMPL_H__
#define __CEGLAYERCALLBACKIMPL_H__

#include "config.h"

#if USE(ACCELERATED_COMPOSITING)

#include "GraphicsLayerSilk.h"
using namespace WebCore;
typedef GraphicsLayerSilk GLayerSilk;

#else //#if USE(ACCELERATED_COMPOSITING)

typedef void GLayerSilk;

#endif //#if USE(ACCELERATED_COMPOSITING)

struct ICEVGContext;

class CEGLayerCallbackImpl
{
public:

	~CEGLayerCallbackImpl()
	{
		_glayerSilk = 0;
	}

	void init(GLayerSilk* glayerSilk)
	{
		_glayerSilk = glayerSilk;
	}

	CEHResult render(ICEVGContext* iVgc);
	CEHResult syncChildren();

private:
	GLayerSilk* _glayerSilk;
};


#endif //__CEGLAYERCALLBACKIMPL_H__

