///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////
#include "config.h"
#include "Assertions.h"
#include "MainThread.h"

namespace WTF {

static void messageHandlerProc(void*, void*, CEUThread_MsgStatus)
{
    dispatchFunctionsFromMainThread();
}

void initializeMainThreadPlatform()
{
}

static CEUThreadRef gMainThread;

CEUThreadRef getMainCEUThreadRef()
{
    return gMainThread;
}

void setMainCEUThreadRef(CEUThreadRef thread)
{
    gMainThread = thread;
}

void scheduleDispatchFunctionsOnMainThread()
{
    CEHResult hr = CEUThread_postMessage(getMainCEUThreadRef(), (void*)1, &messageHandlerProc, NULL, 0);
    ASSERT_UNUSED(hr, CESucceeded(hr));
}

} // namespace WTF
