/* cairo - a vector graphics library with display and print output
 *
 * Copyright © 2010 Red Hat Inc.
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and
 * limitations under the License.
 *
 * The Original Code is the cairo graphics library.
 *
 * The Initial Developer of the Original Code is University of Southern
 * California.
 *
 * Contributor(s):
 *	Benjamin Otte <otte@redhat.com>
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the _____ license (the  "[___] License"), in which case the
 * provisions of [______] License are applicable instead of those
 * above. If you wish to allow use of your version of this file only
 * under the terms of the [____] License and not to allow others to use
 * your version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice and
 * other provisions required by the [___] License. If you do not delete
 * the provisions above, a recipient may use your version of this file
 * under either the MPL or the [___] License."
 *
 * NOTE: The text of this Exhibit A may differ slightly from the text
 * of the notices in the Source Code files of the Original Code. You
 * should use the text of this Exhibit A rather than the text found in
 * the Original Code Source Code for Your Modifications. 
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "cairo-gobject.h"

#define CAIRO_DEFINE_BOXED(Name,underscore_name,copy_func,free_func) \
GType \
underscore_name ## _get_type (void) \
{ \
   static volatile gsize type_volatile = 0; \
   if (g_once_init_enter (&type_volatile)) { \
      GType type = g_boxed_type_register_static (g_intern_static_string (Name), \
                                                 (GBoxedCopyFunc)copy_func, \
                                                 (GBoxedFreeFunc)free_func); \
      g_once_init_leave (&type_volatile, type); \
   } \
   return type_volatile; \
}

CAIRO_DEFINE_BOXED ("CairoContext", cairo_gobject_context, 
                    cairo_reference, cairo_destroy);
CAIRO_DEFINE_BOXED ("CairoDevice", cairo_gobject_device, 
                    cairo_device_reference, cairo_device_destroy);
CAIRO_DEFINE_BOXED ("CairoPattern", cairo_gobject_pattern, 
                    cairo_pattern_reference, cairo_pattern_destroy);
CAIRO_DEFINE_BOXED ("CairoSurface", cairo_gobject_surface, 
                    cairo_surface_reference, cairo_surface_destroy);
CAIRO_DEFINE_BOXED ("CairoScaledFont", cairo_gobject_scaled_font, 
                    cairo_scaled_font_reference, cairo_scaled_font_destroy);
CAIRO_DEFINE_BOXED ("CairoFontFace", cairo_gobject_font_face, 
                    cairo_font_face_reference, cairo_font_face_destroy);
CAIRO_DEFINE_BOXED ("CairoFontOptions", cairo_gobject_font_options, 
                    cairo_font_options_copy, cairo_font_options_destroy);
CAIRO_DEFINE_BOXED ("CairoRegion", cairo_gobject_region, 
                    cairo_region_reference, cairo_region_destroy);

#define COPY_FUNC(name) \
static gpointer \
cairo_gobject_cairo_ ## name ## _copy (gpointer src) \
{ \
    return g_memdup (src, sizeof (cairo_ ## name ## _t)); \
}

COPY_FUNC (rectangle)
CAIRO_DEFINE_BOXED ("CairoRectangle", cairo_gobject_rectangle, 
                    cairo_gobject_cairo_rectangle_copy, g_free);
COPY_FUNC (rectangle_int)
CAIRO_DEFINE_BOXED ("CairoRectangleInt", cairo_gobject_rectangle_int, 
                    cairo_gobject_cairo_rectangle_int_copy, g_free);

