/*
 * Copyright © 2007 Keith Packard
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and
 * limitations under the License.
 *
 * The Original Code is the cairo graphics library.
 *
 * The Initial Developer of the Original Code is Keith Packard
 *
 * Contributor(s):
 *      Keith Packard <keithp@keithp.com>
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the _____ license (the  "[___] License"), in which case the
 * provisions of [______] License are applicable instead of those
 * above. If you wish to allow use of your version of this file only
 * under the terms of the [____] License and not to allow others to use
 * your version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice and
 * other provisions required by the [___] License. If you do not delete
 * the provisions above, a recipient may use your version of this file
 * under either the MPL or the [___] License."
 *
 * NOTE: The text of this Exhibit A may differ slightly from the text
 * of the notices in the Source Code files of the Original Code. You
 * should use the text of this Exhibit A rather than the text found in
 * the Original Code Source Code for Your Modifications. 
 */
#include "cairo-test.h"

static cairo_test_status_t
draw (cairo_t *cr, int width, int height)
{
    double  xscale, yscale;
    cairo_set_source_rgb (cr, 1, 1, 1);
    cairo_paint (cr);

    cairo_set_source_rgb (cr, 0, 0, 0);
    cairo_set_miter_limit (cr, 100000);
    for (xscale = 1; xscale <= 1000; xscale += 999)
	for (yscale = 1; yscale <= 1000; yscale += 999)
	{
	    double  max_scale = xscale > yscale ? xscale : yscale;
	    cairo_save (cr);
	    if (xscale > 1)
		cairo_translate (cr, 50, 0);
	    if (yscale > 1)
		cairo_translate (cr, 0, 50);
	    cairo_scale (cr, xscale, yscale);
	    cairo_set_line_width (cr, 10.0 / max_scale);
	    cairo_move_to (cr, 10.0 / xscale, 10.0 / yscale);
	    cairo_line_to (cr, 40.0 / xscale, 10.0 / yscale);
	    cairo_line_to (cr, 10.0 / xscale, 30.0 / yscale);
	    cairo_stroke (cr);
	    cairo_restore (cr);
	}

    return CAIRO_TEST_SUCCESS;
}

CAIRO_TEST (miter_precision,
	    "test how cairo deals with small miters"
	    "\ncurrent code draws inappropriate bevels at times",
	    "stoke, stress", /* keywords */
	    NULL, /* requirements */
	    120, 100,
	    NULL, draw)
