/* Cairo - a vector graphics library with display and print output
 *
 * Copyright © 2009 Chris Wilson
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and
 * limitations under the License.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the _____ license (the  "[___] License"), in which case the
 * provisions of [______] License are applicable instead of those
 * above. If you wish to allow use of your version of this file only
 * under the terms of the [____] License and not to allow others to use
 * your version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice and
 * other provisions required by the [___] License. If you do not delete
 * the provisions above, a recipient may use your version of this file
 * under either the MPL or the [___] License."
 *
 * NOTE: The text of this Exhibit A may differ slightly from the text
 * of the notices in the Source Code files of the Original Code. You
 * should use the text of this Exhibit A rather than the text found in
 * the Original Code Source Code for Your Modifications. 
 */

#ifndef CAIRO_DRM_RADEON_PRIVATE_H
#define CAIRO_DRM_RADEON_PRIVATE_H

#include "cairo-compiler-private.h"
#include "cairo-types-private.h"
#include "cairo-drm-private.h"
#include "cairo-freelist-private.h"

#define RADEON_GEM_DOMAIN_CPU		0x1
#define RADEON_GEM_DOMAIN_GTT		0x2
#define RADEON_GEM_DOMAIN_VRAM		0x4

typedef struct _radeon_bo {
    cairo_drm_bo_t base;

    void *virtual;

    cairo_bool_t in_batch;
    uint32_t read_domains;
    uint32_t write_domain;
} radeon_bo_t;

typedef struct _radeon_device {
    cairo_drm_device_t base;
    cairo_freepool_t bo_pool;

    uint64_t vram_limit;
    uint64_t gart_limit;
} radeon_device_t;

cairo_private cairo_status_t
radeon_device_init (radeon_device_t *device, int fd);

cairo_private void
radeon_device_fini (radeon_device_t *device);

cairo_private cairo_bool_t
radeon_info (int fd,
             uint64_t *gart_size,
	     uint64_t *vram_size);

cairo_private void
radeon_bo_write (const radeon_device_t *dev,
	         radeon_bo_t *bo,
		 unsigned long offset,
		 unsigned long size,
		 const void *data);

cairo_private void
radeon_bo_read (const radeon_device_t *dev,
	        radeon_bo_t *bo,
	        unsigned long offset,
		unsigned long size,
		void *data);

cairo_private void
radeon_bo_wait (const radeon_device_t *dev, radeon_bo_t *bo);

cairo_private void *
radeon_bo_map (const radeon_device_t *dev, radeon_bo_t *bo);

cairo_private void
radeon_bo_unmap (radeon_bo_t *bo);

cairo_private cairo_drm_bo_t *
radeon_bo_create (radeon_device_t *dev,
		  uint32_t size,
		  uint32_t initial_domain);

cairo_private cairo_drm_bo_t *
radeon_bo_create_for_name (radeon_device_t *dev, uint32_t name);

cairo_private cairo_surface_t *
radeon_bo_get_image (const radeon_device_t *device,
	             radeon_bo_t *bo,
		     const cairo_drm_surface_t *surface);

#endif /* CAIRO_DRM_RADEON_PRIVATE_H */
