/* cairo - a vector graphics library with display and print output
 *
 * Copyright © 2009 Intel Corporation
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and
 * limitations under the License.
 *
 * Contributor(s):
 *	Chris Wilson <chris@chris-wilson.co.uk>
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the _____ license (the  "[___] License"), in which case the
 * provisions of [______] License are applicable instead of those
 * above. If you wish to allow use of your version of this file only
 * under the terms of the [____] License and not to allow others to use
 * your version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice and
 * other provisions required by the [___] License. If you do not delete
 * the provisions above, a recipient may use your version of this file
 * under either the MPL or the [___] License."
 *
 * NOTE: The text of this Exhibit A may differ slightly from the text
 * of the notices in the Source Code files of the Original Code. You
 * should use the text of this Exhibit A rather than the text found in
 * the Original Code Source Code for Your Modifications. 
 */

#include "cairoint.h"

#include "cairo-clip-private.h"
#include "cairo-xcb-private.h"

cairo_int_status_t
_cairo_xcb_surface_cairo_paint (cairo_xcb_surface_t	*surface,
				cairo_operator_t	 op,
				const cairo_pattern_t	*source,
				cairo_clip_t		*clip)
{
    return CAIRO_INT_STATUS_UNSUPPORTED;
}

cairo_int_status_t
_cairo_xcb_surface_cairo_mask (cairo_xcb_surface_t	*surface,
			       cairo_operator_t		 op,
			       const cairo_pattern_t	*source,
			       const cairo_pattern_t	*mask,
			       cairo_clip_t		*clip)
{
    return CAIRO_INT_STATUS_UNSUPPORTED;
}

cairo_int_status_t
_cairo_xcb_surface_cairo_stroke (cairo_xcb_surface_t	*surface,
				 cairo_operator_t	 op,
				 const cairo_pattern_t	*source,
				 cairo_path_fixed_t	*path,
				 const cairo_stroke_style_t	*style,
				 const cairo_matrix_t		*ctm,
				 const cairo_matrix_t		*ctm_inverse,
				 double			 tolerance,
				 cairo_antialias_t	 antialias,
				 cairo_clip_t		*clip)
{
    return CAIRO_INT_STATUS_UNSUPPORTED;
}

cairo_int_status_t
_cairo_xcb_surface_cairo_fill (cairo_xcb_surface_t	*surface,
			       cairo_operator_t		 op,
			       const cairo_pattern_t	*source,
			       cairo_path_fixed_t	*path,
			       cairo_fill_rule_t	 fill_rule,
			       double			 tolerance,
			       cairo_antialias_t	 antialias,
			       cairo_clip_t		*clip)
{
    return CAIRO_INT_STATUS_UNSUPPORTED;
}

cairo_int_status_t
_cairo_xcb_surface_cairo_glyphs (cairo_xcb_surface_t	*surface,
				 cairo_operator_t		 op,
				 const cairo_pattern_t	*source,
				 cairo_scaled_font_t	*scaled_font,
				 cairo_glyph_t		*glyphs,
				 int			 num_glyphs,
				 cairo_clip_t		*clip)
{
    return CAIRO_INT_STATUS_UNSUPPORTED;
}
