/* vim: set sw=4 sts=4 et cin: */
/* cairo - a vector graphics library with display and print output
 *
 * Copyright (c) 2005-2006 netlabs.org
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and
 * limitations under the License.
 *
 * The Original Code is the cairo graphics library.
 *
 * The Initial Developer of the Original Code is
 *     Doodle <doodle@scenergy.dfmk.hu>
 *
 * Contributor(s):
 *     Peter Weilbacher <mozilla@Weilbacher.org>
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the _____ license (the  "[___] License"), in which case the
 * provisions of [______] License are applicable instead of those
 * above. If you wish to allow use of your version of this file only
 * under the terms of the [____] License and not to allow others to use
 * your version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice and
 * other provisions required by the [___] License. If you do not delete
 * the provisions above, a recipient may use your version of this file
 * under either the MPL or the [___] License."
 *
 * NOTE: The text of this Exhibit A may differ slightly from the text
 * of the notices in the Source Code files of the Original Code. You
 * should use the text of this Exhibit A rather than the text found in
 * the Original Code Source Code for Your Modifications. 
 */

#ifndef CAIRO_OS2_PRIVATE_H
#define CAIRO_OS2_PRIVATE_H

#include "cairo-os2.h"
#include "cairoint.h"

typedef struct _cairo_os2_surface
{
    cairo_surface_t        base;

    /* Mutex semaphore to protect private fields from concurrent access */
    HMTX                   hmtx_use_private_fields;
    /* Private fields: */
    HPS                    hps_client_window;
    HWND                   hwnd_client_window;
    BITMAPINFO2            bitmap_info;
    unsigned char         *pixels;
    cairo_image_surface_t *image_surface;
    int                    pixel_array_lend_count;
    HEV                    hev_pixel_array_came_back;

    RECTL                  rcl_dirty_area;
    cairo_bool_t           dirty_area_present;

    /* General flags: */
    cairo_bool_t           blit_as_changes;
    cairo_bool_t           use_24bpp;
} cairo_os2_surface_t;

#endif /* CAIRO_OS2_PRIVATE_H */
