/* cairo - a vector graphics library with display and print output
 *
 * Copyright © 2009 Intel Corporation
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and
 * limitations under the License.
 *
 * The Original Code is the cairo graphics library.
 *
 * Contributor(s):
 *	Chris Wilson <chris@chris-wilson.co.uk>
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the _____ license (the  "[___] License"), in which case the
 * provisions of [______] License are applicable instead of those
 * above. If you wish to allow use of your version of this file only
 * under the terms of the [____] License and not to allow others to use
 * your version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice and
 * other provisions required by the [___] License. If you do not delete
 * the provisions above, a recipient may use your version of this file
 * under either the MPL or the [___] License."
 *
 * NOTE: The text of this Exhibit A may differ slightly from the text
 * of the notices in the Source Code files of the Original Code. You
 * should use the text of this Exhibit A rather than the text found in
 * the Original Code Source Code for Your Modifications. 
 */

#ifndef CAIRO_BOXES_H
#define CAIRO_BOXES_H

#include "cairo-types-private.h"
#include "cairo-compiler-private.h"

struct _cairo_boxes_t {
    cairo_status_t status;
    cairo_box_t limit;
    const cairo_box_t *limits;
    int num_limits;
    int num_boxes;
    unsigned int is_pixel_aligned : 1;

    struct _cairo_boxes_chunk {
	struct _cairo_boxes_chunk *next;
	cairo_box_t *base;
	int count;
	int size;
    } chunks, *tail;
    cairo_box_t boxes_embedded[32];
};

cairo_private void
_cairo_boxes_init (cairo_boxes_t *boxes);

cairo_private void
_cairo_boxes_init_for_array (cairo_boxes_t *boxes,
			     cairo_box_t *array,
			     int num_boxes);

cairo_private void
_cairo_boxes_limit (cairo_boxes_t	*boxes,
		    const cairo_box_t	*limits,
		    int			 num_limits);

cairo_private cairo_status_t
_cairo_boxes_add (cairo_boxes_t *boxes,
		  const cairo_box_t *box);

cairo_private void
_cairo_boxes_extents (const cairo_boxes_t *boxes,
		      cairo_rectangle_int_t *extents);

cairo_private void
_cairo_boxes_clear (cairo_boxes_t *boxes);

cairo_private void
_cairo_boxes_fini (cairo_boxes_t *boxes);

#endif /* CAIRO_BOXES_H */
