/* Cairo - a vector graphics library with display and print output
 *
 * Copyright © 2009 Chris Wilson
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and
 * limitations under the License.
 *
 * The Original Code is the cairo graphics library.
 *
 * The Initial Developer of the Original Code is Chris Wilson.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the _____ license (the  "[___] License"), in which case the
 * provisions of [______] License are applicable instead of those
 * above. If you wish to allow use of your version of this file only
 * under the terms of the [____] License and not to allow others to use
 * your version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice and
 * other provisions required by the [___] License. If you do not delete
 * the provisions above, a recipient may use your version of this file
 * under either the MPL or the [___] License."
 *
 * NOTE: The text of this Exhibit A may differ slightly from the text
 * of the notices in the Source Code files of the Original Code. You
 * should use the text of this Exhibit A rather than the text found in
 * the Original Code Source Code for Your Modifications. 
 */

#include "cairo-boilerplate-private.h"

#include <cairo-drm.h>

static cairo_surface_t *
_cairo_boilerplate_drm_create_surface (const char		 *name,
				       cairo_content_t		  content,
				       double			  width,
				       double			  height,
				       double			  max_width,
				       double			  max_height,
				       cairo_boilerplate_mode_t   mode,
				       int			  id,
				       void			**closure)
{
    cairo_device_t *device;
    cairo_format_t format;

    device = cairo_drm_device_default ();
    if (device == NULL)
	return NULL; /* skip tests if no supported h/w found */

    switch (content) {
    case CAIRO_CONTENT_ALPHA: format = CAIRO_FORMAT_A8; break;
    case CAIRO_CONTENT_COLOR: format = CAIRO_FORMAT_RGB24; break;
    default:
    case CAIRO_CONTENT_COLOR_ALPHA: format = CAIRO_FORMAT_ARGB32; break;
    }

    return *closure = cairo_drm_surface_create (device, format, width, height);
}

static void
_cairo_boilerplate_drm_synchronize (void *closure)
{
    cairo_surface_t *image;

    image = cairo_drm_surface_map_to_image (closure);
    if (cairo_surface_status (image) == CAIRO_STATUS_SUCCESS)
	cairo_drm_surface_unmap (closure, image);
}

static const cairo_boilerplate_target_t targets[] = {
    /* Acceleration architectures may make the results differ by a
     * bit, so we set the error tolerance to 1. */
    {
	"drm", "drm", NULL, NULL,
	CAIRO_SURFACE_TYPE_DRM, CAIRO_CONTENT_COLOR_ALPHA, 1,
	"cairo_drm_surface_create",
	_cairo_boilerplate_drm_create_surface,
	NULL, NULL,
	_cairo_boilerplate_get_image_surface,
	cairo_surface_write_to_png,
	NULL,
	_cairo_boilerplate_drm_synchronize,
        NULL,
	TRUE, FALSE, FALSE
    },
    {
	"drm", "drm", NULL, NULL,
	CAIRO_SURFACE_TYPE_DRM, CAIRO_CONTENT_COLOR, 1,
	"cairo_drm_surface_create",
	_cairo_boilerplate_drm_create_surface,
	NULL, NULL,
	_cairo_boilerplate_get_image_surface,
	cairo_surface_write_to_png,
	NULL,
	_cairo_boilerplate_drm_synchronize,
        NULL,
	FALSE, FALSE, FALSE
    },
};
CAIRO_BOILERPLATE (drm, targets)
