// Copyright 2020 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Wancho`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v13.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x01E2FF
  ],
  ranges: [
    [0x01E2C0, 0x01E2F9]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Wancho}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Wancho}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Wcho}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Wcho}"
);
testPropertyEscapes(
  /^\p{scx=Wancho}+$/u,
  matchSymbols,
  "\\p{scx=Wancho}"
);
testPropertyEscapes(
  /^\p{scx=Wcho}+$/u,
  matchSymbols,
  "\\p{scx=Wcho}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x01E2BF],
    [0x01E2FA, 0x01E2FE],
    [0x01E300, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Wancho}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Wancho}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Wcho}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Wcho}"
);
testPropertyEscapes(
  /^\P{scx=Wancho}+$/u,
  nonMatchSymbols,
  "\\P{scx=Wancho}"
);
testPropertyEscapes(
  /^\P{scx=Wcho}+$/u,
  nonMatchSymbols,
  "\\P{scx=Wcho}"
);
