// Copyright 2020 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Javanese`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v13.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00A980, 0x00A9CD],
    [0x00A9CF, 0x00A9D9],
    [0x00A9DE, 0x00A9DF]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Javanese}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Javanese}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Java}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Java}"
);
testPropertyEscapes(
  /^\p{scx=Javanese}+$/u,
  matchSymbols,
  "\\p{scx=Javanese}"
);
testPropertyEscapes(
  /^\p{scx=Java}+$/u,
  matchSymbols,
  "\\p{scx=Java}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x00A9CE
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00A97F],
    [0x00A9DA, 0x00A9DD],
    [0x00A9E0, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Javanese}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Javanese}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Java}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Java}"
);
testPropertyEscapes(
  /^\P{scx=Javanese}+$/u,
  nonMatchSymbols,
  "\\P{scx=Javanese}"
);
testPropertyEscapes(
  /^\P{scx=Java}+$/u,
  nonMatchSymbols,
  "\\P{scx=Java}"
);
