// Copyright 2020 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Yezidi`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v13.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x010E80, 0x010EA9],
    [0x010EAB, 0x010EAD],
    [0x010EB0, 0x010EB1]
  ]
});
testPropertyEscapes(
  /^\p{Script=Yezidi}+$/u,
  matchSymbols,
  "\\p{Script=Yezidi}"
);
testPropertyEscapes(
  /^\p{Script=Yezi}+$/u,
  matchSymbols,
  "\\p{Script=Yezi}"
);
testPropertyEscapes(
  /^\p{sc=Yezidi}+$/u,
  matchSymbols,
  "\\p{sc=Yezidi}"
);
testPropertyEscapes(
  /^\p{sc=Yezi}+$/u,
  matchSymbols,
  "\\p{sc=Yezi}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x010EAA
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x010E7F],
    [0x010EAE, 0x010EAF],
    [0x010EB2, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Yezidi}+$/u,
  nonMatchSymbols,
  "\\P{Script=Yezidi}"
);
testPropertyEscapes(
  /^\P{Script=Yezi}+$/u,
  nonMatchSymbols,
  "\\P{Script=Yezi}"
);
testPropertyEscapes(
  /^\P{sc=Yezidi}+$/u,
  nonMatchSymbols,
  "\\P{sc=Yezidi}"
);
testPropertyEscapes(
  /^\P{sc=Yezi}+$/u,
  nonMatchSymbols,
  "\\P{sc=Yezi}"
);
