// Copyright 2020 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Medefaidrin`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v13.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x016E40, 0x016E9A]
  ]
});
testPropertyEscapes(
  /^\p{Script=Medefaidrin}+$/u,
  matchSymbols,
  "\\p{Script=Medefaidrin}"
);
testPropertyEscapes(
  /^\p{Script=Medf}+$/u,
  matchSymbols,
  "\\p{Script=Medf}"
);
testPropertyEscapes(
  /^\p{sc=Medefaidrin}+$/u,
  matchSymbols,
  "\\p{sc=Medefaidrin}"
);
testPropertyEscapes(
  /^\p{sc=Medf}+$/u,
  matchSymbols,
  "\\p{sc=Medf}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x016E3F],
    [0x016E9B, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Medefaidrin}+$/u,
  nonMatchSymbols,
  "\\P{Script=Medefaidrin}"
);
testPropertyEscapes(
  /^\P{Script=Medf}+$/u,
  nonMatchSymbols,
  "\\P{Script=Medf}"
);
testPropertyEscapes(
  /^\P{sc=Medefaidrin}+$/u,
  nonMatchSymbols,
  "\\P{sc=Medefaidrin}"
);
testPropertyEscapes(
  /^\P{sc=Medf}+$/u,
  nonMatchSymbols,
  "\\P{sc=Medf}"
);
