// Copyright 2020 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Bopomofo`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v13.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x0002EA, 0x0002EB],
    [0x003105, 0x00312F],
    [0x0031A0, 0x0031BF]
  ]
});
testPropertyEscapes(
  /^\p{Script=Bopomofo}+$/u,
  matchSymbols,
  "\\p{Script=Bopomofo}"
);
testPropertyEscapes(
  /^\p{Script=Bopo}+$/u,
  matchSymbols,
  "\\p{Script=Bopo}"
);
testPropertyEscapes(
  /^\p{sc=Bopomofo}+$/u,
  matchSymbols,
  "\\p{sc=Bopomofo}"
);
testPropertyEscapes(
  /^\p{sc=Bopo}+$/u,
  matchSymbols,
  "\\p{sc=Bopo}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x0002E9],
    [0x0002EC, 0x003104],
    [0x003130, 0x00319F],
    [0x0031C0, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Bopomofo}+$/u,
  nonMatchSymbols,
  "\\P{Script=Bopomofo}"
);
testPropertyEscapes(
  /^\P{Script=Bopo}+$/u,
  nonMatchSymbols,
  "\\P{Script=Bopo}"
);
testPropertyEscapes(
  /^\P{sc=Bopomofo}+$/u,
  nonMatchSymbols,
  "\\P{sc=Bopomofo}"
);
testPropertyEscapes(
  /^\P{sc=Bopo}+$/u,
  nonMatchSymbols,
  "\\P{sc=Bopo}"
);
